<?php

namespace AgeGate\Region\Presentation;

use AgeGate\Utility\Cookie;
use AgeGate\Common\Settings;
use AgeGate\Utility\Encrypt;
use AgeGate\Utility\Facades\View;

class Region
{
    private static $settings = [];

    public function __construct()
    {
        if (!self::$settings) {
            self::$settings = get_option('wp_age_gate_regions', []);
        }

        add_action('age_gate/passed', function ($response) {
            if ($response['user_data']['region'] ?? false) {
                $cookieName = Settings::getInstance()->getCookieName() . '_region';
                Cookie::set($cookieName, $response['user_data']['region']);
            }
        });

        add_filter('age_gate/form/post_data', function ($data) {
            $age = self::$settings['region'][$data['age_gate']['age']]['age'] ?? false;

            if ($age) {
                $data['age_gate']['region'] = $data['age_gate']['age'];
                $data['age_gate']['age'] = (new Encrypt)->encrypt($age);
            } else {
                unset($data['age_gate']['age']);
            }
            return $data;
        });

        add_filter('age_gate/response/user_data', function ($data, $submission, $raw) {
            $data['region'] = $raw['age_gate']['age'];
            return $data;
        }, 10, 3);



        add_action('plugins_loaded', function () {
            remove_action('age_gate/fields/age_field', 'age_gate_template_age_field');

            $action = (self::$settings['labels']['placement'] ?? false) === 'after' ? "age_gate/custom/after" : "age_gate/custom/before";
            add_action($action, [$this, 'ageField']);
        }, 100);

        add_filter('age_gate/validation/names', function ($names) {
            $names['age_gate.age'] = __('region', 'age-gate-region');
            return $names;
        });
    }

    public function ageField()
    {
        View::addFolder('regions', AGE_GATE_REGION_PATH . 'src/Resources/views/public');
        // require_once AGE_GATE_REGION_PATH . 'src/Resources/views/public/dropdown.php';

        View::render('regions::dropdown', [
            'options' => self::$settings,
        ]);
    }
}
